/*************************************************************************************
			NOTE Silicium628

Les fonctions ci-dessous sont inspirées le plus directement possible de la lecture du pdf "TEF668X User Manuel" (NPX)
Je n'utilise pas l'opérateur conditionnel ternaire ((condition) ? a : b)  qui, bien que de haut niveau 
et permettant une écriture concise, ne facilite pas la lisibilité du programme.

**************************************************************************************/


#include <Arduino.h>
#include "Wire.h"
#include "driverTEF6686_628.h"

byte addr_ISP  = 0x64;

#define conv8to16(a) ((uint16_t)(((uint16_t)(*(a))) << 8 |((uint16_t)(*(a+1)))))


void Write2(uint8_t *buf, uint8_t len)
{	
	Wire.beginTransmission(addr_ISP);
	for (int i = 0; i < len; i++)
	{
		Wire.write(*buf++);
	}
	Wire.endTransmission();
}


void Set_Cmd(uint8_t module, uint8_t cmd, int len, ...)
{
	uint8_t i;
	uint8_t buf[31];
	uint16_t temp;
	va_list vArgs;
	va_start(vArgs, len);
	buf[0] = module;
	buf[1] = cmd;
	buf[2] = 1;
	for (i = 0; i < len; i++)
	{
    	temp = va_arg(vArgs, int);
		buf[3 + i * 2] = (uint8_t)(temp >> 8);
		buf[4 + i * 2] = (uint8_t)temp;
	}

	va_end(vArgs);
	Write2(buf, len * 2 + 3);
}


void Set_Volume(int v)
{
	Set_Cmd(48, 11, 1, 0);  //unmute  (IMPORTANT sinon débute en mode MUTE...)
    int MapVolume = map(v, 0, 100, -599, 50);
    Set_Cmd(48, 10, 1, MapVolume); // module 48 : AUDIO = Audio processing
}



void Tune_Frequence_FM(uint16_t F)
{
	uint8_t octet_L, octet_H;

	octet_L = F%256;
	octet_H = F/256;

	Wire.beginTransmission(addr_ISP);
		Wire.write(0x20);
		Wire.write(0x01);
		Wire.write(0x01);
		Wire.write(0x00);
		Wire.write(0x01);
		Wire.write(octet_H); 
		Wire.write(octet_L);
	Wire.endTransmission();
}


void Tune_Frequence_AM(uint16_t F)
{
	uint8_t octet_L, octet_H;

	octet_L = F%256;
	octet_H = F/256;

	Wire.beginTransmission(addr_ISP);
		Wire.write(0x21);
		Wire.write(0x01);
		Wire.write(0x01);
		Wire.write(0x00);
		Wire.write(0x01);
		Wire.write(octet_H); 
		Wire.write(octet_L);
	Wire.endTransmission();
}



void Set_Mute(boolean M)
{
	if (M == true) //radio standby mode (low-power mode without radio functionality)
	{
		Wire.beginTransmission(addr_ISP);
			Wire.write(0x40);
			Wire.write(0x01);
			Wire.write(0x01);
		Wire.endTransmission();
	}	
	else	// normal operation
	{
		Wire.beginTransmission(addr_ISP);
			Wire.write(0x40);
			Wire.write(0x01);
			Wire.write(0x00);
		Wire.endTransmission();
	}
}


void Set_no_AM_gain_reduction()
{
	Wire.beginTransmission(addr_ISP);
		Wire.write(0x21); // 33
		Wire.write(0x0C); // 12
		Wire.write(0x01);
		Wire.write(0x00);
		Wire.write(0x00);
	Wire.endTransmission();
}


bool Tuner_WriteBuffer(uint8_t *buf, uint16_t len) 
{
	Wire.beginTransmission(0x64);
		for (uint16_t i = 0; i < len; i++) {Wire.write(buf[i]);}
	uint8_t r = Wire.endTransmission();
	delay(2);
	if(r==0) {return 1;} 
	else {return 0;} // l'opérateur conditionnel ternaire (?) c'est pas mon truc !
}


bool Tuner_ReadBuffer(uint8_t *buf, uint16_t len) 
{
	Wire.requestFrom(0x64, len);
	if (Wire.available() == len) 
	{
		for (uint16_t i = 0; i < len; i++) { buf[i] = Wire.read(); }
		return 1;
	}
	else {return 0;}
}


bool Tuner_Get_Cmd(uint8_t module, uint8_t cmd, uint8_t *receive, uint16_t len) 
{
	uint8_t buf[3];
	buf[0] = module;
	buf[1] = cmd;
	buf[2] = 1;
  
	Tuner_WriteBuffer(buf, 3);
	return Tuner_ReadBuffer(receive, len); // 1 si ok, 0 si erreur
}


void Get_Quality (
	// paramètres passés par adresse (donc variables), tous actualisés par cette fonction
	// tous des uint16_t ou int16_t sauf le dernier int8_t
	//ce qui nous fait 7*2 +1 = 15 octets lus dans le module
	uint8_t module,
	uint16_t *status, 
	int16_t *level, 
	uint16_t *usn, 
	uint16_t *wam, 
	int16_t *offset, 
	uint16_t *bandwidth, 
	uint16_t *mod, 
	int8_t *snr 	) 
{
	uint8_t buf[14];

	uint16_t r = Tuner_Get_Cmd(module, 129, buf, sizeof(buf));

// voir datasheet du TEF6686
// actualisation des paramètres
	*status = conv8to16(buf);
	*level = conv8to16(buf + 2);
	*usn = conv8to16(buf + 4); // noise
	*wam = conv8to16(buf + 6); // ‘wideband-AM’
	*offset = conv8to16(buf + 8); //radio frequency offset
	*bandwidth = conv8to16(buf + 10) / 10; // IF bandwidth
	*mod = conv8to16(buf + 12) / 10; // modulation detector
	if (*level < -200) *level = -200;
	if (*level > 1200) *level = 1200;
	*snr = int(0.46222375 * (float)(*level) / 10 - 0.082495118 * (float)(*usn) / 10) + 10;
}


bool Get_RDS_Data (
	uint16_t *status, 
	uint16_t *A_block, 
	uint16_t *B_block, 
	uint16_t *C_block, 
	uint16_t *D_block, 
	uint16_t *dec_error) 
{
	uint8_t buf[12];
	uint8_t r = Tuner_Get_Cmd(32, 131, buf, sizeof(buf));
	*status = conv8to16(buf);
	*A_block = conv8to16(buf + 2);
	*B_block = conv8to16(buf + 4);
	*C_block = conv8to16(buf + 6);
	*D_block = conv8to16(buf + 8);
	*dec_error = conv8to16(buf + 10);
	return r;
}