
#include <stdint.h>
#include "FS.h"
#include "SD.h"


void init_SDcard()
{
	String s1;
	
	tft.fillRect(0, 0, _DX, _DY, NOIR); // efface
	tft.setTextColor(BLANC, NOIR);
	//tft.setFreeFont(FF0);

	uint16_t y=0;
	
	y+=20;

	s1="version " + version;
	tft.drawString(s1, 0, y);
	
	y+=40;
	tft.setTextColor(VERT, NOIR);
	tft.drawString("Init SDcard", 0, y);
	y+=20;
	
	
 	if(!SD.begin())
	{
		tft.drawString("Card Mount Failed", 0, y);
		delay (2000);
		tft.fillRect(0, 0, _DX, _DY, NOIR); // efface
		return;
	}
  

    uint8_t cardType = SD.cardType();

    if(cardType == CARD_NONE)
    {
        tft.drawString("No SDcard", 0, y);
        delay (2000);
		tft.fillRect(0, 0, _DX, _DY, NOIR); // efface
        return;
    }

    flag_SDcardOk=1;

    tft.drawString("SDcard Type: ", 0, y);
	if(cardType == CARD_SD)    {tft.drawString("SDSC", 150, y);}
    else if(cardType == CARD_SDHC) {tft.drawString("SDHC", 150, y);}

	y+=20;
	
	uint32_t cardSize = SD.cardSize() / (1024 * 1024);
	s1=(String)cardSize + " GB";
	tft.drawString("SDcard size: ", 0, y);
	tft.drawString(s1, 150, y);

   // listDir(SD, "/", 0);
    
    //Serial.printf("Total space: %lluMB\n", SD.totalBytes() / (1024 * 1024));
    //Serial.printf("Used space: %lluMB\n", SD.usedBytes() / (1024 * 1024));

	delay (1000);
	tft.fillRect(0, 0, _DX, _DY, NOIR); // efface
	
}


/** -----------------------------------------------------------------------------------
		CAPTURE D'ECRAN vers SDcard				
/** ----------------------------------------------------------------------------------- */

void write_TFT_on_SDcard() // enregistre le fichier .bmp
{

	//tft.setTextColor(VERT, NOIR);
	//tft.drawString("CP", 450, 300);
	
	if (flag_SDcardOk==0) {return;}

	String s1;
	uint16_t ys=200;
	//tft.setFreeFont(FF0);
	tft.setTextColor(JAUNE, NOIR);
	
	uint16_t x, y;
	uint16_t color565;
	uint16_t bmp_color;
	uint8_t R, G, B;
	
	if( ! SD.exists("/bmp/capture2.bmp"))
	{
		tft.fillRect(0, 0, _DX, _DY, NOIR); // efface
		tft.setTextColor(ROUGE, NOIR);
		tft.drawString("NO /bmp/capture2.bmp !", 100, ys);
		delay(300);
		tft.fillRect(100, ys, 220, 20, NOIR); // efface
		return;
	}


	File File1 = SD.open("/bmp/capture2.bmp", FILE_WRITE); // ouverture du fichier binaire (vierge) en écriture
	if (File1)
	{
/*
Les images en couleurs réelles BMP888 utilisent 24 bits par pixel: 
Il faut 3 octets pour coder chaque pixel, en respectant l'ordre de l'alternance bleu, vert et rouge.
*/
		uint16_t bmp_offset = 138;
		File1.seek(bmp_offset);

		
		tft.setTextColor(VERT, NOIR);;	
		
		for (y = _DY; y>0; y--)
		{
			for (x=0; x < _DX; x++)
			{
				color565=tft.readPixel(x, y);

				RGB565_to_888(color565, &R, &G, &B);
				
				File1.write(B); //G
				File1.write(G); //R
				File1.write(R); //B
			}

			s1=(String) (y/10);
			tft.fillRect(_DX -30, _DY -30, 20, 20, NOIR);
			tft.drawString(s1, _DY -30, 300);// affi compte à rebour
		} 

		File1.close();  // referme le fichier
		tft.fillRect(_DX -30, _DY -30, 20, 20, NOIR); // efface le compte à rebour
	}
}
