#include <Arduino.h>


/** ***********************************************************************************
	CLASS VOYANT  // sorte de LED qui peut s'allumer de différentes couleurs et afficher un mot				
***************************************************************************************/

class TOUCH_BOUTON
{
    public:
        uint16_t x0;
        uint16_t y0;
        uint16_t dx;
        uint16_t dy;
        uint16_t dr; // rayon de courbure des angles
        String s;
        boolean cliked;
        boolean selected;

        TOUCH_BOUTON(); // constructeur

        void init(uint16_t x, uint16_t y, uint16_t dx, uint16_t dy, uint16_t dri);
        void affiche(uint16_t coul_fill_unselect, uint16_t coul_fill_select, uint8_t n_font);

    private:

};


class TOUCH_BOUTON_PRESET : public TOUCH_BOUTON
{
    public:
        uint32_t frequence;
        String nom;
        uint16_t couleur;

        TOUCH_BOUTON_PRESET(); // constructeur

    private:

};


class NUM_PAD
{
    public:
        uint8_t x0;
        uint8_t y0;

        uint8_t dx;
        uint8_t dy;

        TOUCH_BOUTON bt_num0, bt_num1, bt_num2, bt_num3, bt_num4, bt_num5, bt_num6, bt_num7, bt_num8, bt_num9;
        TOUCH_BOUTON pad[10];
        
        TOUCH_BOUTON bt_point;
	    TOUCH_BOUTON bt_ok;

        NUM_PAD(); // constructeur

        void init(uint16_t x0, uint16_t y0, boolean fond);
        uint8_t test_clic();

    private:
   
};


/** ***************************************************************************************
	CLASS GROUPE_FREQUENCES  // objet image d'un bloc mémoire en EEPROM
	permet diverses manipulations en RAM (tri...) sans toucher à l'EEPROM					
********************************************************************************************/
class GROUPE_FREQUENCES
{
    public:
        uint32_t G_freq[100];
        uint16_t adr_0; // adresse du groupe en EEPROM
        uint16_t adr_1ere_frq; // près un tri les F=0 se retrouvent en haut de liste. La 1ere F se retrouve donc bien plus bas
        uint16_t nb_freq; // nombre de fréquences !=0 enregistées
        uint16_t num_F_actuelle;

        GROUPE_FREQUENCES(); // constructeur

        void load_bloc(); // depuis l'EEPROM
        void bloc_to_serial();  // pour tests
        void tri_bloc(); // par valeur numérique des fréquences
 
    private:

};



// ************************************************************************************


void setup();
void loop();
void init_sprites();
void affiche_unit(String s);
void affiche_band(String s);
void affiche_box_entete();
void affiche_box_choix_couleur();
void affi_valeurs_RGB();
void affiche_box_FRQ(uint16_t couleur);
void affiche_box_presets();
void deselect_boutons_presets();
void affiche_box_BANDE();
void affiche_box_EEPROM();
void affiche_box_FRQ(uint16_t couleur);
void affiche_frequence(uint32_t frq); // en kHz
void affiche_index_frq();
void clic_logiciel_bouton(TOUCH_BOUTON *bouton_i);
void dessine_VuMetre();
void init_box_info();

//void Tune_Frequence_FM(uint16_t F);
void Set_Volume(int v);