#ifndef DRIVER_TEF628_H
#define DRIVER_TEF628_H

#include <Arduino.h>

/*
The TEF668X consists of four modules:

    -module 32 : FM = FM radio reception
    -module 33 : AM = LW, MW and SW radio reception
    -module 48 : AUDIO = Audio processing
    -module 64 : APPL = System and application control
*/

void Set_Cmd(uint8_t module, uint8_t cmd, int len, ...);
void Set_Volume(int v);
void Tune_Frequence_FM(uint16_t F);
void Tune_Frequence_AM(uint16_t F);
void Set_Mute(boolean M);
void Set_no_AM_gain_reduction();
uint16_t readRSSI();
bool Tuner_WriteBuffer(uint8_t *buf, uint16_t len); 

bool Tuner_ReadBuffer(uint8_t *buf, uint16_t len); 


void Get_Quality (
	uint8_t module,
	uint16_t *status, 
	int16_t *level, 
	uint16_t *usn, 
	uint16_t *wam, 
	int16_t *offset, 
	uint16_t *bandwidth, 
	uint16_t *mod, 
	int8_t *snr ); 

bool Get_RDS_Data (
	uint16_t *status, 
	uint16_t *A_block, 
	uint16_t *B_block, 
	uint16_t *C_block, 
	uint16_t *D_block, 
	uint16_t *dec_error);


#endif