
#ifndef CONSTANTES_628H
#define CONSTANTES_628H

#include <Arduino.h>

// un outil en ligne bien utile pour composer les couleurs RGB565
// https://rgbcolorpicker.com/565
// ici couleurs RGB565 sur 16 bits, écrites en décimal pour une manipulation simple dans l'éditeur VScode
uint16_t NOIR=   		0x000;
uint16_t MARRON =  		35520; //17 22 0
uint16_t ROUGE = 		63488;
uint16_t ROUGE_FONCE = 	38912;
uint16_t ROSE	=		64402;
uint16_t ORANGE =		62400;
uint16_t JAUNE  = 		65504;
uint16_t JAUNE_2  = 	52672;
uint16_t JAUNE_PALE =	63347;
uint16_t VERT =  		2016;
uint16_t VERT_FONCE =	10976;
uint16_t OLIVE=			23744;
uint16_t CYAN   = 		2047;
uint16_t BLEU_CLAIR =	26079;
uint16_t BLEU =  		31;
uint16_t BLEU_2 =		6;
uint16_t BLEU_3 =		2;
uint16_t MAGENTA =		63519;
uint16_t VIOLET	=		41021;
uint16_t VIOLET_CLAIR=	54303;
uint16_t GRIS_1 =		57083;
uint16_t GRIS_2 =		44373;
uint16_t GRIS_3 =		35921;
uint16_t GRIS_4 = 		21162;
uint16_t GRIS_5 = 		8452;
uint16_t GRIS_6 = 		2081;
uint16_t BLANC  = 		65535;

#define nb_stations_RDS 26 
// pas de caractères accentués pour rester compatible avec UTF8
static const char* const codesRDS[nb_stations_RDS] PROGMEM =
{
	"F201 France Inter",  	// 0
	"F202 France Culture", 	// 1
	"F203 France Musique",
	"F204 FIP",
	"F206 France Info",
	"F211 RTL",
	"F212 RFM",
	"F213 Europe 1",
	"F214 Skyrock",
	"F215 RTL 2",
	"F216 RMC",
	"F217 Fun Radio",
	"F218 Nostalgie",
	"F220 NRJ",
	"F221 Radio Classique",
	"F223 TSF JAZZ",
	"F224 Cherie FM",
	"F226 Rire et Chansons",
	"F405 ici Provence",
	"F209 ici Roussillon",
	"F20A ici Herault",
	"F22F Jazz Radio",
	"F21D Oui FM",
	"F6A0 Radio Clapas",
	"F463 Radio Frequence Mediterranee",
	"F650 Sud Radio" //26
}; // en fait pour la France, il y en a >1000, voir le site de l'ARCOM



#endif