#include <Arduino.h>
#include "Wire.h"

#define TIMER_INTERVAL 66
#define RDS_TIMER_INTERVAL 87
#define AM_VOL_SCALE -1
#define INIT_FLAG_TIMER  0xff
#define INIT_FLAG_PATCH1 0xfe
#define INIT_FLAG_PATCH2 0xfd

byte DSP_I2C = 0x64;
/*
0x64 correspond à l'adresse I2C du TEF6686 sur 7 bits, comme c'est généralement le cas dans les 
programmes Arduino (adresse sur 7 bits avec bits de lecture/écriture séparés).
En hexadécimal,
0x64 correspond à 1100100 en binaire  sur 7 bits
0xC9 correspond à 11001001 en binaire sur 8 bits l'adresse de lecture du TEF6686 sur 8 bits (bits de lecture/écriture inclus).
*/

int16_t nDeemphasis, volume;



const uint8_t AMFilterMap[] PROGMEM = { 30, 40, 60, 80, 30, 40, 60, 80, 30, 40, 60, 80, 30, 40, 60, 80 };
const uint16_t FMFilterMap[] PROGMEM = { 560, 640, 720, 840, 970, 1140, 1330, 1510, 1680, 1840, 2000, 2170, 2360, 2540, 2870, 3110 };


const unsigned char tuner_init_tab9216[] PROGMEM = 
{
  3, 0x14, 0x00, 0x01,
  2, 0xff, 50,
  9, 0x40, 0x04, 0x01, 0x00, 0x8C, 0xA0, 0x00, 0x00, 0x00,
  5, 0x40, 0x05, 0x01, 0x00, 0x01,
  2, 0xff, 100,
};
